/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.api.player;

import java.util.UUID;
import net.potatocloud.api.CloudAPI;
import net.potatocloud.api.property.PropertyHolder;
import net.potatocloud.api.service.Service;

public interface CloudPlayer
extends PropertyHolder {
    public String getUsername();

    public UUID getUniqueId();

    public String getConnectedProxyName();

    public String getConnectedServiceName();

    default public Service getConnectedProxy() {
        return CloudAPI.getInstance().getServiceManager().getService(this.getConnectedProxyName());
    }

    default public Service getConnectedService() {
        return CloudAPI.getInstance().getServiceManager().getService(this.getConnectedServiceName());
    }

    default public void connectWithService(Service service) {
        CloudAPI.getInstance().getPlayerManager().connectPlayerWithService(this, service);
    }

    default public void connectWithService(String serviceName) {
        this.connectWithService(CloudAPI.getInstance().getServiceManager().getService(serviceName));
    }

    default public void update() {
        CloudAPI.getInstance().getPlayerManager().updatePlayer(this);
    }
}

