/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.api.player;

import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.player.CloudPlayer;
import net.potatocloud.api.service.Service;

public interface CloudPlayerManager {
    public CloudPlayer getCloudPlayer(String var1);

    public CloudPlayer getCloudPlayer(UUID var1);

    public Set<CloudPlayer> getOnlinePlayers();

    default public Set<CloudPlayer> getOnlinePlayersByGroup(ServiceGroup group) {
        return this.getOnlinePlayers().stream().filter(player -> player.getConnectedService() != null && player.getConnectedService().getServiceGroup().getName().equals(group.getName())).collect(Collectors.toSet());
    }

    public void connectPlayerWithService(String var1, String var2);

    default public void connectPlayerWithService(CloudPlayer player, String serviceName) {
        this.connectPlayerWithService(player.getUsername(), serviceName);
    }

    default public void connectPlayerWithService(String playerName, Service service) {
        this.connectPlayerWithService(playerName, service.getName());
    }

    default public void connectPlayerWithService(CloudPlayer player, Service service) {
        this.connectPlayerWithService(player, service.getName());
    }

    public void updatePlayer(CloudPlayer var1);
}

