/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.api.property;

import lombok.Generated;

public class Property<T> {
    private final String name;
    private final T defaultValue;
    private T value;

    public void setValueObject(Object value) {
        this.value = value;
    }

    public T getValue() {
        return this.value != null ? this.value : this.defaultValue;
    }

    public static Property<String> ofString(String name, String defaultValue) {
        return new Property<String>(name, defaultValue, defaultValue);
    }

    public static Property<Integer> ofInteger(String name, int defaultValue) {
        return new Property<Integer>(name, defaultValue, defaultValue);
    }

    public static Property<Boolean> ofBoolean(String name, boolean defaultValue) {
        return new Property<Boolean>(name, defaultValue, defaultValue);
    }

    public static Property<Float> ofFloat(String name, float defaultValue) {
        return new Property<Float>(name, Float.valueOf(defaultValue), Float.valueOf(defaultValue));
    }

    public static <T> Property<T> of(String name, T defaultValue, T value) {
        return new Property<T>(name, defaultValue, value);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public Property(String name, T defaultValue, T value) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.value = value;
    }

    @Generated
    public void setValue(T value) {
        this.value = value;
    }
}

