/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.api.property;

import java.util.List;
import java.util.Map;
import net.potatocloud.api.CloudAPI;
import net.potatocloud.api.event.events.property.PropertyChangedEvent;
import net.potatocloud.api.property.Property;

public interface PropertyHolder {
    public Map<String, Property<?>> getPropertyMap();

    default public List<Property<?>> getProperties() {
        return this.getPropertyMap().values().stream().toList();
    }

    public String getPropertyHolderName();

    default public <T> Property<T> getProperty(String name) {
        return this.getPropertyMap().get(name);
    }

    default public <T> Property<T> getProperty(Property<T> property) {
        return this.getProperty(property.getName());
    }

    default public <T> void setProperty(Property<T> property, T value, boolean fireEvent) {
        Property<T> existing = this.getProperty(property.getName());
        Object oldValue = null;
        if (existing != null) {
            oldValue = existing.getValue();
            if (oldValue.equals(value)) {
                return;
            }
            existing.setValue(value);
            property = existing;
        } else {
            property.setValue(value);
            this.getPropertyMap().put(property.getName(), property);
        }
        if (fireEvent) {
            CloudAPI.getInstance().getEventManager().call(new PropertyChangedEvent(this.getPropertyHolderName(), property, oldValue, value));
        }
    }

    default public <T> void setProperty(Property<T> property, T value) {
        this.setProperty(property, value, true);
    }

    default public <T> void setProperty(Property<T> property) {
        this.setProperty(property, property.getValue());
    }

    default public boolean hasProperty(String name) {
        return this.getPropertyMap().containsKey(name);
    }

    default public boolean hasProperty(Property<?> property) {
        return this.getPropertyMap().containsValue(property);
    }
}

