/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.api.utils;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import lombok.Generated;

public final class TimeFormatter {
    public static String formatAsDuration(long millis) {
        Duration duration = Duration.ofMillis(millis);
        long totalDays = duration.toDays();
        long months = totalDays / 30L;
        long weeks = totalDays % 30L / 7L;
        long days = totalDays % 7L;
        long hours = duration.toHours() % 24L;
        long minutes = duration.toMinutes() % 60L;
        long seconds = duration.getSeconds() % 60L;
        StringBuilder builder = new StringBuilder();
        if (months > 0L) {
            builder.append(months).append("mo ");
        }
        if (weeks > 0L) {
            builder.append(weeks).append("w ");
        }
        if (days > 0L) {
            builder.append(days).append("d ");
        }
        if (hours > 0L) {
            builder.append(hours).append("h ");
        }
        if (minutes > 0L) {
            builder.append(minutes).append("m ");
        }
        builder.append(seconds).append("s");
        return builder.toString().trim();
    }

    public static String formatAsDateAndTime(long millis) {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault()).format(Instant.ofEpochMilli(millis));
    }

    @Generated
    private TimeFormatter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

