/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.core.event;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.potatocloud.api.event.Event;
import net.potatocloud.api.event.EventListener;
import net.potatocloud.api.event.EventManager;

public abstract class BaseEventManager
implements EventManager {
    protected final Map<Class<? extends Event>, List<EventListener<?>>> listeners = new ConcurrentHashMap();

    @Override
    public <T extends Event> void on(Class<T> eventClass, EventListener<T> listener) {
        this.listeners.computeIfAbsent(eventClass, key -> new CopyOnWriteArrayList()).add(listener);
    }

    @Override
    public <T extends Event> void callLocal(T event) {
        List<EventListener<?>> eventListenerList = this.listeners.get(event.getClass());
        if (eventListenerList == null) {
            return;
        }
        Iterator<EventListener<?>> iterator = eventListenerList.iterator();
        while (iterator.hasNext()) {
            EventListener<?> e;
            EventListener<?> listener = e = iterator.next();
            listener.onEvent(event);
        }
    }
}

