/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.core.event;

import net.potatocloud.api.event.Event;
import net.potatocloud.core.event.BaseEventManager;
import net.potatocloud.core.event.EventSerializer;
import net.potatocloud.core.networking.NetworkServer;

public class ServerEventManager
extends BaseEventManager {
    private final NetworkServer server;

    public ServerEventManager(NetworkServer server) {
        this.server = server;
        server.registerPacketListener(300, (connection, packet) -> {
            Event event = EventSerializer.deserialize(packet);
            if (event != null) {
                this.callLocal(event);
                server.getConnectedSessions().stream().filter(networkConnection -> !networkConnection.equals(connection)).forEach(networkConnection -> networkConnection.send(packet));
            }
        });
    }

    @Override
    public <T extends Event> void call(T event) {
        this.callLocal(event);
        this.server.broadcastPacket(EventSerializer.serialize(event));
    }
}

