/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.core.networking;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import net.potatocloud.core.networking.NetworkConnection;
import net.potatocloud.core.networking.Packet;
import net.potatocloud.core.networking.PacketListener;

public class PacketManager {
    private final Map<Integer, Supplier<? extends Packet>> packets = new HashMap<Integer, Supplier<? extends Packet>>();
    private final Map<Integer, List<PacketListener<? extends Packet>>> listeners = new HashMap<Integer, List<PacketListener<? extends Packet>>>();

    public void register(int id, Supplier<? extends Packet> packet) {
        this.packets.put(id, packet);
    }

    public <T extends Packet> void registerListener(int id, PacketListener<T> listener) {
        this.listeners.computeIfAbsent(id, key -> new CopyOnWriteArrayList()).add(listener);
    }

    public Packet createPacket(int id) {
        return this.packets.get(id).get();
    }

    public <T extends Packet> void onPacket(NetworkConnection connection, Packet packet) {
        List<PacketListener<? extends Packet>> packetListeners = this.listeners.get(packet.getId());
        if (packetListeners == null) {
            return;
        }
        for (PacketListener<? extends Packet> listener : packetListeners) {
            listener.onPacket(connection, packet);
        }
    }
}

