/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.core.networking.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import lombok.Generated;
import net.potatocloud.core.networking.Packet;
import net.potatocloud.core.networking.PacketManager;
import net.potatocloud.core.networking.PacketToBigException;
import net.potatocloud.core.networking.netty.PacketBuffer;

public class NettyPacketDecoder
extends ByteToMessageDecoder {
    private final PacketManager packetManager;
    private static final int MAX_PACKET_SIZE = 65536;

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 4) {
            return;
        }
        in.markReaderIndex();
        int length = in.readInt();
        if (length > 65536) {
            ctx.close();
            throw new PacketToBigException(length);
        }
        if (in.readableBytes() < length) {
            in.resetReaderIndex();
            return;
        }
        int packetId = in.readInt();
        Packet packet = this.packetManager.createPacket(packetId);
        if (packet == null) {
            return;
        }
        packet.read(new PacketBuffer(in));
        out.add(packet);
    }

    @Generated
    public NettyPacketDecoder(PacketManager packetManager) {
        this.packetManager = packetManager;
    }
}

