/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.core.networking.netty;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.PlatformVersion;
import net.potatocloud.api.platform.impl.PlatformImpl;
import net.potatocloud.api.platform.impl.PlatformVersionImpl;
import net.potatocloud.api.property.Property;

public class PacketBuffer {
    private final ByteBuf buf;

    public void writeString(String string) {
        if (string == null) {
            this.buf.writeInt(-1);
            return;
        }
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        this.buf.writeInt(bytes.length);
        this.buf.writeBytes(bytes);
    }

    public String readString() {
        int length = this.buf.readInt();
        if (length == -1) {
            return null;
        }
        byte[] bytes = new byte[length];
        this.buf.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public void writeInt(int value) {
        this.buf.writeInt(value);
    }

    public int readInt() {
        return this.buf.readInt();
    }

    public void writeBoolean(boolean bool) {
        this.buf.writeBoolean(bool);
    }

    public boolean readBoolean() {
        return this.buf.readBoolean();
    }

    public void writeStringList(List<String> list) {
        this.writeInt(list.size());
        for (String item : list) {
            this.writeString(item);
        }
    }

    public List<String> readStringList() {
        int size = this.readInt();
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.readString());
        }
        return list;
    }

    public void writeObject(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            this.buf.writeByte(1);
            this.writeString(string);
        } else if (object instanceof Integer) {
            Integer integer = (Integer)object;
            this.buf.writeByte(2);
            this.writeInt(integer);
        } else if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            this.buf.writeByte(3);
            this.writeBoolean(bool);
        } else if (object instanceof Long) {
            Long l = (Long)object;
            this.buf.writeByte(4);
            this.writeLong(l);
        } else if (object instanceof Float) {
            Float f = (Float)object;
            this.buf.writeByte(5);
            this.writeFloat(f.floatValue());
        } else {
            throw new IllegalArgumentException("Unsupported object: " + String.valueOf(object.getClass()));
        }
    }

    public Object readObject() {
        byte type = this.buf.readByte();
        return switch (type) {
            case 1 -> this.readString();
            case 2 -> this.readInt();
            case 3 -> this.readBoolean();
            case 4 -> this.readLong();
            case 5 -> Float.valueOf(this.readFloat());
            default -> throw new IllegalArgumentException("Unknown object id: " + type);
        };
    }

    public <T> void writeProperty(Property<T> property) {
        this.writeString(property.getName());
        this.writeObject(property.getDefaultValue());
        this.writeObject(property.getValue());
    }

    public Property<?> readProperty() {
        String name = this.readString();
        Object defaultValue = this.readObject();
        Object value = this.readObject();
        return Property.of(name, defaultValue, value);
    }

    public void writePropertyMap(Map<String, Property<?>> propertyMap) {
        this.writeInt(propertyMap.size());
        for (Property<?> prop : propertyMap.values()) {
            this.writeProperty(prop);
        }
    }

    public Map<String, Property<?>> readPropertyMap() {
        int size = this.readInt();
        HashMap map = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            Property<?> property = this.readProperty();
            map.put(property.getName(), property);
        }
        return map;
    }

    public void writeLong(long value) {
        this.buf.writeLong(value);
    }

    public long readLong() {
        return this.buf.readLong();
    }

    public void writeFloat(float value) {
        this.buf.writeFloat(value);
    }

    public float readFloat() {
        return this.buf.readFloat();
    }

    public void writePlatform(Platform platform) {
        this.writeString(platform.getName());
        this.writeString(platform.getDownloadUrl());
        this.writeBoolean(platform.isCustom());
        this.writeBoolean(platform.isProxy());
        this.writeString(platform.getBase());
        this.writeString(platform.getPreCacheBuilder());
        this.writeString(platform.getParser());
        this.writeString(platform.getHashType());
        this.writeStringList(platform.getPrepareSteps());
        this.writeInt(platform.getVersions().size());
        for (PlatformVersion version : platform.getVersions()) {
            this.writeString(version.getPlatformName());
            this.writeString(version.getName());
            this.writeBoolean(version.isLocal());
            this.writeString(version.getDownloadUrl());
            this.writeString(version.getFileHash());
            this.writeBoolean(version.isLegacy());
        }
    }

    public Platform readPlatform() {
        String name = this.readString();
        String downloadUrl = this.readString();
        boolean custom = this.readBoolean();
        boolean isProxy = this.readBoolean();
        String base = this.readString();
        String preCacheBuilder = this.readString();
        String parser = this.readString();
        String hashType = this.readString();
        List<String> prepareSteps = this.readStringList();
        PlatformImpl platform = new PlatformImpl(name, downloadUrl, custom, isProxy, base, preCacheBuilder, parser, hashType, prepareSteps);
        int versionCount = this.readInt();
        for (int i = 0; i < versionCount; ++i) {
            String platformName = this.readString();
            String versionName = this.readString();
            boolean local = this.readBoolean();
            String versionDownloadUrl = this.readString();
            String fileHash = this.readString();
            boolean legacy = this.readBoolean();
            PlatformVersionImpl version = new PlatformVersionImpl(platformName, versionName, local, versionDownloadUrl, fileHash, legacy);
            platform.getVersions().add(version);
        }
        return platform;
    }

    @Generated
    public PacketBuffer(ByteBuf buf) {
        this.buf = buf;
    }
}

