/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node;

import java.nio.file.Path;
import lombok.Generated;
import net.potatocloud.api.CloudAPI;
import net.potatocloud.api.event.EventManager;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.group.ServiceGroupManager;
import net.potatocloud.api.player.CloudPlayerManager;
import net.potatocloud.api.property.PropertyHolder;
import net.potatocloud.api.service.Service;
import net.potatocloud.core.event.ServerEventManager;
import net.potatocloud.core.networking.NetworkServer;
import net.potatocloud.core.networking.PacketManager;
import net.potatocloud.core.networking.netty.NettyNetworkServer;
import net.potatocloud.node.command.CommandManager;
import net.potatocloud.node.command.commands.ClearCommand;
import net.potatocloud.node.command.commands.GroupCommand;
import net.potatocloud.node.command.commands.HelpCommand;
import net.potatocloud.node.command.commands.InfoCommand;
import net.potatocloud.node.command.commands.PlatformCommand;
import net.potatocloud.node.command.commands.PlayerCommand;
import net.potatocloud.node.command.commands.ServiceCommand;
import net.potatocloud.node.command.commands.ShutdownCommand;
import net.potatocloud.node.config.NodeConfig;
import net.potatocloud.node.console.Console;
import net.potatocloud.node.console.ExceptionMessageHandler;
import net.potatocloud.node.console.Logger;
import net.potatocloud.node.group.ServiceGroupManagerImpl;
import net.potatocloud.node.platform.DownloadManager;
import net.potatocloud.node.platform.PlatformManagerImpl;
import net.potatocloud.node.platform.cache.CacheManager;
import net.potatocloud.node.player.CloudPlayerManagerImpl;
import net.potatocloud.node.properties.NodePropertiesHolder;
import net.potatocloud.node.screen.Screen;
import net.potatocloud.node.screen.ScreenManager;
import net.potatocloud.node.service.ServiceDefaultFiles;
import net.potatocloud.node.service.ServiceImpl;
import net.potatocloud.node.service.ServiceManagerImpl;
import net.potatocloud.node.service.ServiceStartQueue;
import net.potatocloud.node.setup.SetupManager;
import net.potatocloud.node.template.TemplateManager;
import net.potatocloud.node.utils.PortCheckUtil;
import net.potatocloud.node.version.UpdateChecker;
import net.potatocloud.node.version.VersionFile;
import org.apache.commons.io.FileUtils;

public class Node
extends CloudAPI {
    private final long startupTime;
    private final NodeConfig config;
    private final CommandManager commandManager;
    private final Console console;
    private final Logger logger;
    private final ScreenManager screenManager;
    private final SetupManager setupManager;
    private final UpdateChecker updateChecker;
    private final PacketManager packetManager;
    private final NetworkServer server;
    private final EventManager eventManager;
    private final NodePropertiesHolder propertiesHolder;
    private final CloudPlayerManager playerManager;
    private final TemplateManager templateManager;
    private final ServiceGroupManager groupManager;
    private final PlatformManagerImpl platformManager;
    private final DownloadManager downloadManager;
    private final CacheManager cacheManager;
    private final ServiceManagerImpl serviceManager;
    private final ServiceStartQueue serviceStartQueue;
    private final String previousVersion;
    private boolean ready = false;
    private boolean isStopping;

    public Node(long startupTime) {
        this.startupTime = startupTime;
        this.config = new NodeConfig();
        if (PortCheckUtil.isPortInUse(this.config.getNodeHost(), this.config.getNodePort())) {
            System.err.println("The configured node port is already in use. Is another instance of potatocloud already running on this port?");
            System.exit(0);
        }
        this.previousVersion = VersionFile.getVersion();
        VersionFile.create();
        this.commandManager = new CommandManager();
        this.console = new Console(this.commandManager, this);
        this.logger = new Logger(this.console, Path.of(this.config.getLogsFolder(), new String[0]));
        new ExceptionMessageHandler(this.logger);
        this.screenManager = new ScreenManager(this.console, this.logger);
        Screen nodeScreen = new Screen("node_screen");
        this.screenManager.addScreen(nodeScreen);
        this.screenManager.setCurrentScreen(nodeScreen);
        this.console.start();
        this.setupManager = new SetupManager();
        this.updateChecker = new UpdateChecker(this.logger);
        this.updateChecker.checkForUpdates();
        this.packetManager = new PacketManager();
        this.server = new NettyNetworkServer(this.packetManager);
        this.server.start(this.config.getNodeHost(), this.config.getNodePort());
        this.logger.info("NetworkServer started using &aNetty &7on &a" + this.config.getNodeHost() + "&8:&a" + this.config.getNodePort());
        this.eventManager = new ServerEventManager(this.server);
        this.propertiesHolder = new NodePropertiesHolder(this.server);
        this.playerManager = new CloudPlayerManagerImpl(this.server);
        this.templateManager = new TemplateManager(this.logger, Path.of(this.config.getTemplatesFolder(), new String[0]));
        this.groupManager = new ServiceGroupManagerImpl(Path.of(this.config.getGroupsFolder(), new String[0]), this.server);
        ((ServiceGroupManagerImpl)this.groupManager).loadGroups();
        if (!this.groupManager.getAllServiceGroups().isEmpty()) {
            this.logger.info("Loaded &a" + this.groupManager.getAllServiceGroups().size() + "&7 Service Groups&8:");
            for (ServiceGroup group : this.groupManager.getAllServiceGroups()) {
                this.logger.info("&8\u00bb &a" + group.getName());
            }
        }
        this.platformManager = new PlatformManagerImpl(this.logger, this.server);
        this.downloadManager = new DownloadManager(Path.of(this.config.getPlatformsFolder(), new String[0]), this.logger);
        this.cacheManager = new CacheManager(this.logger);
        ServiceDefaultFiles.copyDefaultFiles(this.logger, this.config, this.getClass().getClassLoader());
        this.serviceManager = new ServiceManagerImpl(this.config, this.logger, this.server, this.eventManager, this.groupManager, this.screenManager, this.templateManager, this.platformManager, this.downloadManager, this.cacheManager, this.console);
        this.serviceStartQueue = new ServiceStartQueue(this.groupManager, this.serviceManager);
        this.registerCommands();
        this.logger.info("Startup completed in &a" + (System.currentTimeMillis() - startupTime) + "ms &8| &7Use &8'&ahelp&8' &7to see available commands");
        this.serviceStartQueue.start();
        this.ready = true;
    }

    private void registerCommands() {
        this.commandManager.registerCommand(new GroupCommand(this.logger, this.groupManager));
        this.commandManager.registerCommand(new ServiceCommand(this.logger, this.serviceManager, this.groupManager));
        this.commandManager.registerCommand(new ShutdownCommand(this));
        this.commandManager.registerCommand(new PlatformCommand(this.logger, this.platformManager, this.downloadManager));
        this.commandManager.registerCommand(new ClearCommand(this.console));
        this.commandManager.registerCommand(new HelpCommand(this.logger, this.commandManager));
        this.commandManager.registerCommand(new PlayerCommand(this.logger, this.playerManager, this.serviceManager));
        this.commandManager.registerCommand(new InfoCommand(this.logger));
    }

    public void shutdown() {
        this.isStopping = true;
        this.logger.info("&7Starting node &cshutdown&7...");
        this.serviceStartQueue.close();
        for (Service service : this.serviceManager.getAllServices()) {
            ((ServiceImpl)service).shutdownBlocking();
        }
        this.server.shutdown();
        FileUtils.deleteDirectory(Path.of(this.config.getTempServicesFolder(), new String[0]).toFile());
        this.logger.info("&7Shutdown complete. Goodbye!");
        this.console.close();
    }

    public long getUptime() {
        return System.currentTimeMillis() - this.startupTime;
    }

    public static Node getInstance() {
        return (Node)CloudAPI.getInstance();
    }

    @Override
    public ServiceGroupManager getServiceGroupManager() {
        return this.groupManager;
    }

    @Override
    public PropertyHolder getGlobalProperties() {
        return this.propertiesHolder;
    }

    @Generated
    public long getStartupTime() {
        return this.startupTime;
    }

    @Generated
    public NodeConfig getConfig() {
        return this.config;
    }

    @Generated
    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    @Generated
    public Console getConsole() {
        return this.console;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public ScreenManager getScreenManager() {
        return this.screenManager;
    }

    @Generated
    public SetupManager getSetupManager() {
        return this.setupManager;
    }

    @Generated
    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    @Generated
    public PacketManager getPacketManager() {
        return this.packetManager;
    }

    @Generated
    public NetworkServer getServer() {
        return this.server;
    }

    @Override
    @Generated
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Generated
    public NodePropertiesHolder getPropertiesHolder() {
        return this.propertiesHolder;
    }

    @Override
    @Generated
    public CloudPlayerManager getPlayerManager() {
        return this.playerManager;
    }

    @Generated
    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    @Generated
    public ServiceGroupManager getGroupManager() {
        return this.groupManager;
    }

    @Override
    @Generated
    public PlatformManagerImpl getPlatformManager() {
        return this.platformManager;
    }

    @Generated
    public DownloadManager getDownloadManager() {
        return this.downloadManager;
    }

    @Generated
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    @Generated
    public ServiceManagerImpl getServiceManager() {
        return this.serviceManager;
    }

    @Generated
    public ServiceStartQueue getServiceStartQueue() {
        return this.serviceStartQueue;
    }

    @Generated
    public String getPreviousVersion() {
        return this.previousVersion;
    }

    @Generated
    public boolean isReady() {
        return this.ready;
    }

    @Generated
    public boolean isStopping() {
        return this.isStopping;
    }
}

