/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command.commands.group;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.group.ServiceGroupManager;
import net.potatocloud.api.property.DefaultProperties;
import net.potatocloud.api.property.Property;
import net.potatocloud.core.utils.PropertyUtil;
import net.potatocloud.node.command.SubCommand;
import net.potatocloud.node.command.SubCommandInfo;
import net.potatocloud.node.command.TabCompleter;
import net.potatocloud.node.command.TabCompleters;
import net.potatocloud.node.console.Logger;

@SubCommandInfo(name="property", description="Manage properties of the given service group", usage="group property &8[&alist&8|&aset&8|&aremove&8] [&agroup&8] [&akey&8] [&avalue&8]")
public class GroupPropertySubCommand
extends SubCommand
implements TabCompleter {
    private final ServiceGroupManager groupManager;
    private final Logger logger;

    @Override
    public void execute(String[] args) {
        if (args.length < 1) {
            this.sendUsage();
            return;
        }
        switch (args[0].toLowerCase()) {
            case "list": {
                if (args.length < 2) {
                    this.sendUsage();
                    return;
                }
                String name = args[1];
                ServiceGroup group = this.groupManager.getServiceGroup(name);
                if (group == null) {
                    this.logger.info("&cNo service group found with the name &a" + name);
                    return;
                }
                List<Property<?>> properties = group.getProperties();
                if (properties.isEmpty()) {
                    this.logger.info("No properties found for group &a" + name);
                    return;
                }
                this.logger.info("Properties of group &a" + name + "&8:");
                for (Property<?> property : properties) {
                    this.logger.info("&8\u00bb &a" + property.getName() + " &7- " + String.valueOf(property.getValue()));
                }
                break;
            }
            case "remove": {
                if (args.length < 3) {
                    this.sendUsage();
                    return;
                }
                String name = args[1];
                ServiceGroup group = this.groupManager.getServiceGroup(name);
                if (group == null) {
                    this.logger.info("&cNo service group found with the name &a" + name);
                    return;
                }
                String key = args[2];
                Property property = group.getProperty(key);
                if (property == null) {
                    this.logger.info("Property &a" + key + "&7 was &cnot found &7in group &a" + name);
                    return;
                }
                group.getPropertyMap().remove(property.getName());
                group.update();
                this.logger.info("Property &a" + key + " &7was removed in group &a" + name);
                break;
            }
            case "set": {
                if (args.length < 4) {
                    this.sendUsage();
                    return;
                }
                String name = args[1];
                ServiceGroup group = this.groupManager.getServiceGroup(name);
                if (group == null) {
                    this.logger.info("&cNo service group found with the name &a" + name);
                    return;
                }
                String key = args[2];
                String value = args[3];
                try {
                    Property<?> property = PropertyUtil.stringToProperty(key, value);
                    group.setProperty(property);
                    group.update();
                    this.logger.info("Property &a" + key + " &7was set to &a" + value + " &7in group &a" + name);
                }
                catch (Exception e) {
                    this.sendUsage();
                }
                break;
            }
            default: {
                this.sendUsage();
            }
        }
    }

    @Override
    public List<String> complete(String[] args) {
        String groupName;
        if (args.length == 1) {
            return Stream.of("list", "set", "remove").filter(s -> s.startsWith(args[0].toLowerCase())).toList();
        }
        if (args.length == 2) {
            return TabCompleters.group(args, 1);
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("remove") && this.groupManager.existsServiceGroup(groupName = args[1])) {
            return this.groupManager.getServiceGroup(groupName).getProperties().stream().map(Property::getName).filter(p -> p.startsWith(args[2])).toList();
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("set")) {
            ArrayList<String> completions = new ArrayList<String>();
            completions.add("<custom>");
            completions.addAll(DefaultProperties.asSet().stream().map(Property::getName).filter(s -> s.startsWith(args[2].toLowerCase())).toList());
            return completions;
        }
        return List.of();
    }

    @Generated
    public GroupPropertySubCommand(ServiceGroupManager groupManager, Logger logger) {
        this.groupManager = groupManager;
        this.logger = logger;
    }
}

