/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command.commands.platform;

import java.util.List;
import lombok.Generated;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.PlatformManager;
import net.potatocloud.api.platform.PlatformVersion;
import net.potatocloud.node.command.SubCommand;
import net.potatocloud.node.command.SubCommandInfo;
import net.potatocloud.node.command.TabCompleter;
import net.potatocloud.node.command.TabCompleters;
import net.potatocloud.node.console.Logger;
import net.potatocloud.node.platform.DownloadManager;

@SubCommandInfo(name="download", description="Downloads the given version", usage="platform download &8[&aplatform&8] &8[&aversion&8]")
public class PlatformDownloadSubCommand
extends SubCommand
implements TabCompleter {
    private final PlatformManager platformManager;
    private final Logger logger;
    private final DownloadManager downloadManager;

    @Override
    public void execute(String[] args) {
        if (args.length < 2) {
            this.sendUsage();
            return;
        }
        Platform platform = this.platformManager.getPlatform(args[0]);
        if (platform == null) {
            this.logger.info("This platform does &cnot &7exist");
            return;
        }
        PlatformVersion version = platform.getVersion(args[1]);
        if (version == null) {
            this.logger.info("This version does &7not &7exist for the given platform");
            return;
        }
        this.downloadManager.downloadPlatformVersion(platform, version);
    }

    @Override
    public List<String> complete(String[] args) {
        if (args.length == 1) {
            return TabCompleters.platform(args);
        }
        if (args.length == 2) {
            return TabCompleters.platformVersion(this.platformManager.getPlatform(args[0]), args, 1);
        }
        return List.of();
    }

    @Generated
    public PlatformDownloadSubCommand(PlatformManager platformManager, Logger logger, DownloadManager downloadManager) {
        this.platformManager = platformManager;
        this.logger = logger;
        this.downloadManager = downloadManager;
    }
}

