/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command.commands.platform;

import java.util.List;
import lombok.Generated;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.PlatformManager;
import net.potatocloud.node.command.SubCommand;
import net.potatocloud.node.command.SubCommandInfo;
import net.potatocloud.node.command.TabCompleter;
import net.potatocloud.node.command.TabCompleters;
import net.potatocloud.node.console.Logger;

@SubCommandInfo(name="info", description="Shows information of the given platform", usage="platform info &8[&aplatform&8]")
public class PlatformInfoSubCommand
extends SubCommand
implements TabCompleter {
    private final PlatformManager platformManager;
    private final Logger logger;

    @Override
    public void execute(String[] args) {
        if (args.length < 1) {
            this.sendUsage();
            return;
        }
        Platform platform = this.platformManager.getPlatform(args[0]);
        if (platform == null) {
            this.logger.info("This platform does &cnot &7exist");
            return;
        }
        this.logger.info("&7Info for platform &a" + platform.getName() + "&8:");
        if (platform.getDownloadUrl() != null) {
            this.logger.info("&8\u00bb &7Download URL: &a" + platform.getDownloadUrl());
        }
        this.logger.info("&8\u00bb &7Custom: " + (platform.isCustom() ? "&aYes" : "&cNo"));
        this.logger.info("&8\u00bb &7Proxy: " + (platform.isProxy() ? "&aYes" : "&cNo"));
        this.logger.info("&8\u00bb &7Base: &a" + platform.getBase());
        if (platform.getPreCacheBuilder() != null) {
            this.logger.info("&8\u00bb &7Pre-Cache Builder: &a" + platform.getPreCacheBuilder());
        }
        this.logger.info("&8\u00bb &7Versions: &a" + platform.getVersions().size());
        this.logger.info("&8\u00bb &7Prepare Steps: &a" + platform.getPrepareSteps().size());
        this.logger.info("&8\u00bb &7Parser: &a" + platform.getParser());
        this.logger.info("&8\u00bb &7Hash Type: &a" + platform.getHashType());
    }

    @Override
    public List<String> complete(String[] args) {
        if (args.length == 1) {
            return TabCompleters.platform(args);
        }
        return List.of();
    }

    @Generated
    public PlatformInfoSubCommand(PlatformManager platformManager, Logger logger) {
        this.platformManager = platformManager;
        this.logger = logger;
    }
}

