/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command.commands.platform;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.PlatformManager;
import net.potatocloud.api.platform.PlatformVersion;
import net.potatocloud.node.Node;
import net.potatocloud.node.command.SubCommand;
import net.potatocloud.node.command.SubCommandInfo;
import net.potatocloud.node.command.TabCompleter;
import net.potatocloud.node.command.TabCompleters;
import net.potatocloud.node.console.Logger;
import net.potatocloud.node.setup.setups.AddVersionToPlatformSetup;

@SubCommandInfo(name="version", description="Manage versions of the given platform", usage="platform version &8[&aadd&8|&aremove&8|&alist&8|&ainfo&8] [&aplatform&8] [&aversion&8]")
public class PlatformVersionSubCommand
extends SubCommand
implements TabCompleter {
    private final PlatformManager platformManager;
    private final Logger logger;

    @Override
    public void execute(String[] args) {
        if (args.length < 1) {
            this.sendUsage();
            return;
        }
        switch (args[0].toLowerCase()) {
            case "add": {
                if (args.length < 2) {
                    this.sendUsage();
                    return;
                }
                Platform platform = this.platformManager.getPlatform(args[1]);
                if (platform == null) {
                    this.logger.info("This platform does &cnot &7exist");
                    return;
                }
                Node node = Node.getInstance();
                node.getSetupManager().startSetup(new AddVersionToPlatformSetup(node.getConsole(), node.getScreenManager(), platform, node.getLogger()));
                break;
            }
            case "remove": {
                if (args.length < 3) {
                    this.sendUsage();
                    return;
                }
                Platform platform = this.platformManager.getPlatform(args[1]);
                if (platform == null) {
                    this.logger.info("This platform does &cnot &7exist");
                    return;
                }
                PlatformVersion version = platform.getVersion(args[2]);
                if (version == null) {
                    this.logger.info("This platform version does &cnot &7exist");
                    return;
                }
                ArrayList<PlatformVersion> versions = new ArrayList<PlatformVersion>(platform.getVersions());
                versions.remove(version);
                platform.setVersions(versions);
                platform.update();
                this.logger.info("Version &a" + version.getName() + " &7was removed from platform &a" + platform.getName());
                break;
            }
            case "list": {
                if (args.length < 2) {
                    this.sendUsage();
                    return;
                }
                Platform platform = this.platformManager.getPlatform(args[1]);
                if (platform == null) {
                    this.logger.info("This platform does &cnot &7exist");
                    return;
                }
                List<PlatformVersion> versions = platform.getVersions();
                if (versions.isEmpty()) {
                    this.logger.info("No versions found for platform &a" + platform.getName());
                    return;
                }
                this.logger.info("All versions for platform &a" + platform.getName() + "&8:");
                for (PlatformVersion version : versions) {
                    this.logger.info("&8\u00bb &a" + version.getName() + " &7- Legacy: " + (version.isLegacy() ? "&cYes" : "&aNo"));
                }
                break;
            }
            case "info": {
                if (args.length < 3) {
                    this.sendUsage();
                    return;
                }
                Platform platform = this.platformManager.getPlatform(args[1]);
                if (platform == null) {
                    this.logger.info("This platform does &cnot &7exist");
                    return;
                }
                PlatformVersion version = platform.getVersion(args[2]);
                if (version == null) {
                    this.logger.info("This platform version does &cnot &7exist");
                    return;
                }
                this.logger.info("Information for version &a" + version.getFullName() + "&8:");
                this.logger.info("&8\u00bb &7Platform: &a" + version.getPlatformName());
                this.logger.info("&8\u00bb &7Legacy: " + (version.isLegacy() ? "&cYes" : "&aNo"));
                this.logger.info("&8\u00bb &7Download URL: " + (version.getDownloadUrl() != null ? version.getDownloadUrl() : "&aAuto generated"));
                break;
            }
            default: {
                this.sendUsage();
            }
        }
    }

    @Override
    public List<String> complete(String[] args) {
        if (args.length == 1) {
            return Stream.of("add", "remove", "list", "info").filter(s -> s.startsWith(args[0].toLowerCase())).toList();
        }
        if (args.length == 2 && List.of("add", "remove", "list", "info").contains(args[0].toLowerCase())) {
            return TabCompleters.platform(args, 1);
        }
        if (args.length == 3 && List.of("add", "remove", "info").contains(args[0].toLowerCase())) {
            return TabCompleters.platformVersion(this.platformManager.getPlatform(args[1]), args, 2);
        }
        return List.of();
    }

    @Generated
    public PlatformVersionSubCommand(PlatformManager platformManager, Logger logger) {
        this.platformManager = platformManager;
        this.logger = logger;
    }
}

