/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command.commands.player;

import java.util.Set;
import lombok.Generated;
import net.potatocloud.api.player.CloudPlayer;
import net.potatocloud.api.player.CloudPlayerManager;
import net.potatocloud.node.command.SubCommand;
import net.potatocloud.node.command.SubCommandInfo;
import net.potatocloud.node.console.Logger;

@SubCommandInfo(name="list", description="List online players of the network", usage="player list")
public class PlayerListSubCommand
extends SubCommand {
    private final CloudPlayerManager playerManager;
    private final Logger logger;

    @Override
    public void execute(String[] args) {
        Set<CloudPlayer> players = this.playerManager.getOnlinePlayers();
        if (players.isEmpty()) {
            this.logger.info("There are &cno &7online players");
            return;
        }
        for (CloudPlayer player : players) {
            this.logger.info("&8\u00bb &a" + player.getUsername() + " &7- Proxy: &a" + player.getConnectedProxyName() + " &7- Service: &a" + player.getConnectedServiceName());
        }
    }

    @Generated
    public PlayerListSubCommand(CloudPlayerManager playerManager, Logger logger) {
        this.playerManager = playerManager;
        this.logger = logger;
    }
}

