/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command.commands.service;

import java.util.List;
import lombok.Generated;
import net.potatocloud.api.service.Service;
import net.potatocloud.api.service.ServiceManager;
import net.potatocloud.node.command.SubCommand;
import net.potatocloud.node.command.SubCommandInfo;
import net.potatocloud.node.console.Logger;

@SubCommandInfo(name="list", description="List all services", usage="service list")
public class ServiceListSubCommand
extends SubCommand {
    private final ServiceManager serviceManager;
    private final Logger logger;

    @Override
    public void execute(String[] args) {
        List<Service> services = this.serviceManager.getAllServices();
        if (services.isEmpty()) {
            this.logger.info("There are &cno &7services");
            return;
        }
        this.logger.info("All services&8:");
        for (Service service : services) {
            this.logger.info("&8\u00bb &a" + service.getName() + " &7- Group: &a" + service.getServiceGroup().getName() + " &7- Status: &a" + String.valueOf((Object)service.getStatus()));
        }
    }

    @Generated
    public ServiceListSubCommand(ServiceManager serviceManager, Logger logger) {
        this.serviceManager = serviceManager;
        this.logger = logger;
    }
}

