/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.command.commands.service;

import java.util.List;
import lombok.Generated;
import net.potatocloud.api.service.Service;
import net.potatocloud.api.service.ServiceManager;
import net.potatocloud.node.Node;
import net.potatocloud.node.command.SubCommand;
import net.potatocloud.node.command.SubCommandInfo;
import net.potatocloud.node.command.TabCompleter;
import net.potatocloud.node.command.TabCompleters;
import net.potatocloud.node.console.Logger;
import net.potatocloud.node.screen.Screen;
import net.potatocloud.node.service.ServiceImpl;

@SubCommandInfo(name="screen", description="Switch to the screen of the given service", usage="service screen &8[&aservice&8]")
public class ServiceScreenSubCommand
extends SubCommand
implements TabCompleter {
    private final ServiceManager serviceManager;
    private final Logger logger;

    @Override
    public void execute(String[] args) {
        if (args.length < 1) {
            this.sendUsage();
            return;
        }
        String name = args[0];
        Service service = this.serviceManager.getService(name);
        if (service == null) {
            this.logger.info("&cNo service found with the name &a" + name);
            return;
        }
        if (service instanceof ServiceImpl) {
            ServiceImpl impl = (ServiceImpl)service;
            Screen screen = Node.getInstance().getScreenManager().getScreen(impl.getScreen().getName());
            if (screen == null) {
                this.logger.error("Cant switch to screen of service " + name);
                return;
            }
            Node.getInstance().getScreenManager().switchScreen(screen.getName());
        }
    }

    @Override
    public List<String> complete(String[] args) {
        if (args.length == 1) {
            return TabCompleters.service(args);
        }
        return List.of();
    }

    @Generated
    public ServiceScreenSubCommand(ServiceManager serviceManager, Logger logger) {
        this.serviceManager = serviceManager;
        this.logger = logger;
    }
}

