/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.config;

import java.io.File;
import lombok.Generated;
import org.simpleyaml.configuration.comments.format.YamlCommentFormat;
import org.simpleyaml.configuration.file.YamlFile;

public class NodeConfig {
    private String prompt = "&7&a%user%&7@cloud ~> ";
    private boolean enableBanner = true;
    private int primaryColorCode = 42;
    private boolean logPlayerConnections = true;
    private int serviceStartPort = 30000;
    private int proxyStartPort = 25565;
    private String splitter = "-";
    private boolean platformAutoUpdate = true;
    private String groupsFolder = "groups";
    private String staticFolder = "services/static";
    private String tempServicesFolder = "services/temp";
    private String templatesFolder = "templates";
    private String platformsFolder = "platforms";
    private String logsFolder = "logs";
    private String dataFolder = "data";
    private String nodeHost = "127.0.0.1";
    private int nodePort = 3434;

    public NodeConfig() {
        File file = new File("config.yml");
        YamlFile yaml = new YamlFile(file);
        if (!file.exists()) {
            file.createNewFile();
            this.save(yaml);
        }
        yaml.load();
        this.prompt = yaml.getString("console.prompt", this.prompt);
        this.enableBanner = yaml.getBoolean("console.enable-banner", this.enableBanner);
        this.primaryColorCode = yaml.getInt("console.primary-color", this.primaryColorCode);
        this.logPlayerConnections = yaml.getBoolean("console.log-player-connections", this.logPlayerConnections);
        this.serviceStartPort = yaml.getInt("service.service-start-port", this.serviceStartPort);
        this.proxyStartPort = yaml.getInt("service.proxy-start-port", this.proxyStartPort);
        this.splitter = yaml.getString("service.service-splitter", this.splitter);
        this.platformAutoUpdate = yaml.getBoolean("service.auto-update-platforms", this.platformAutoUpdate);
        this.groupsFolder = yaml.getString("folders.groups", this.groupsFolder);
        this.staticFolder = yaml.getString("folders.static", this.staticFolder);
        this.tempServicesFolder = yaml.getString("folders.temp-services", this.tempServicesFolder);
        this.templatesFolder = yaml.getString("folders.templates", this.templatesFolder);
        this.platformsFolder = yaml.getString("folders.platforms", this.platformsFolder);
        this.logsFolder = yaml.getString("folders.logs", this.logsFolder);
        this.dataFolder = yaml.getString("folders.data", this.dataFolder);
        this.nodeHost = yaml.getString("node.host", this.nodeHost);
        this.nodePort = yaml.getInt("node.port", this.nodePort);
    }

    private void save(YamlFile yaml) {
        yaml.setCommentFormat(YamlCommentFormat.PRETTY);
        yaml.setComment("console.prompt", "Console prompt text (%user% = current user)");
        yaml.set("console.prompt", this.prompt);
        yaml.set("console.enable-banner", this.enableBanner);
        yaml.setComment("console.primary-color", "Primary color code for console messages and prompt (Supported colors: https://www.ditig.com/256-colors-cheat-sheet)");
        yaml.set("console.primary-color", this.primaryColorCode);
        yaml.set("console.log-player-connections", this.logPlayerConnections);
        this.addSpacer(yaml, "service");
        yaml.set("service.service-start-port", this.serviceStartPort);
        yaml.set("service.proxy-start-port", this.proxyStartPort);
        yaml.set("service.service-splitter", this.splitter);
        yaml.setComment("service.auto-update-platforms", "Auto updates platform jars to latest build in the same MC version. Also updates MC version if using 'platform-latest'");
        yaml.set("service.auto-update-platforms", this.platformAutoUpdate);
        this.addSpacer(yaml, "folders");
        yaml.set("folders.groups", this.groupsFolder);
        yaml.set("folders.static", this.staticFolder);
        yaml.set("folders.temp-services", this.tempServicesFolder);
        yaml.set("folders.templates", this.templatesFolder);
        yaml.set("folders.platforms", this.platformsFolder);
        yaml.set("folders.logs", this.logsFolder);
        yaml.set("folders.data", this.dataFolder);
        this.addSpacer(yaml, "node");
        yaml.set("node.host", this.nodeHost);
        yaml.set("node.port", this.nodePort);
        yaml.save();
    }

    private void addSpacer(YamlFile yaml, String key) {
        yaml.setComment(key, "\n");
    }

    @Generated
    public String getPrompt() {
        return this.prompt;
    }

    @Generated
    public boolean isEnableBanner() {
        return this.enableBanner;
    }

    @Generated
    public int getPrimaryColorCode() {
        return this.primaryColorCode;
    }

    @Generated
    public boolean isLogPlayerConnections() {
        return this.logPlayerConnections;
    }

    @Generated
    public int getServiceStartPort() {
        return this.serviceStartPort;
    }

    @Generated
    public int getProxyStartPort() {
        return this.proxyStartPort;
    }

    @Generated
    public String getSplitter() {
        return this.splitter;
    }

    @Generated
    public boolean isPlatformAutoUpdate() {
        return this.platformAutoUpdate;
    }

    @Generated
    public String getGroupsFolder() {
        return this.groupsFolder;
    }

    @Generated
    public String getStaticFolder() {
        return this.staticFolder;
    }

    @Generated
    public String getTempServicesFolder() {
        return this.tempServicesFolder;
    }

    @Generated
    public String getTemplatesFolder() {
        return this.templatesFolder;
    }

    @Generated
    public String getPlatformsFolder() {
        return this.platformsFolder;
    }

    @Generated
    public String getLogsFolder() {
        return this.logsFolder;
    }

    @Generated
    public String getDataFolder() {
        return this.dataFolder;
    }

    @Generated
    public String getNodeHost() {
        return this.nodeHost;
    }

    @Generated
    public int getNodePort() {
        return this.nodePort;
    }
}

