/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.console;

import java.nio.charset.StandardCharsets;
import lombok.Generated;
import net.potatocloud.node.Node;
import net.potatocloud.node.command.CommandManager;
import net.potatocloud.node.console.ConsoleBanner;
import net.potatocloud.node.console.ConsoleColor;
import net.potatocloud.node.console.ConsoleCompleter;
import net.potatocloud.node.console.ConsoleReader;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.InfoCmp;

public class Console {
    private final Terminal terminal;
    private final LineReader lineReader;
    private final ConsoleReader consoleReader;
    private final Node node;
    private String prompt;

    public Console(CommandManager commandManager, Node node) {
        this.node = node;
        this.terminal = TerminalBuilder.builder().name("potatocloud-console").system(true).encoding(StandardCharsets.UTF_8).build();
        this.lineReader = LineReaderBuilder.builder().terminal(this.terminal).completer(new ConsoleCompleter(commandManager)).build();
        this.prompt = this.getDefaultPrompt();
        this.consoleReader = new ConsoleReader(this, commandManager, node);
    }

    public void start() {
        this.clearScreen();
        if (this.node.getConfig().isEnableBanner()) {
            ConsoleBanner.display(this);
        }
        this.consoleReader.start();
    }

    public void println(String message) {
        this.lineReader.printAbove(ConsoleColor.format(message));
    }

    public String getDefaultPrompt() {
        String rawPrompt = this.node.getConfig().getPrompt();
        return ConsoleColor.format(rawPrompt.replace("%user%", System.getProperty("user.name")));
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
        LineReader lineReader = this.lineReader;
        if (lineReader instanceof LineReaderImpl) {
            LineReaderImpl impl = (LineReaderImpl)lineReader;
            impl.setPrompt(prompt);
        }
    }

    public void clearScreen() {
        this.terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
        this.terminal.writer().print("\u001b[H\u001b[2J");
        this.updateScreen();
    }

    public void updateScreen() {
        this.terminal.flush();
        if (this.lineReader.isReading()) {
            this.lineReader.callWidget("redraw-line");
            this.lineReader.callWidget("redisplay");
        }
    }

    public void close() {
        this.consoleReader.interrupt();
        this.terminal.close();
    }

    @Generated
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Generated
    public LineReader getLineReader() {
        return this.lineReader;
    }

    @Generated
    public ConsoleReader getConsoleReader() {
        return this.consoleReader;
    }

    @Generated
    public Node getNode() {
        return this.node;
    }

    @Generated
    public String getPrompt() {
        return this.prompt;
    }
}

