/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.console;

import net.potatocloud.node.Node;
import org.jline.jansi.Ansi;

public enum ConsoleColor {
    DARK_GRAY('8', 240),
    GRAY('7', 188),
    RED('c', 203),
    BLUE('9', 63),
    YELLOW('e', 220),
    GREEN('a', 42),
    WHITE('f', 15);

    private final char code;
    private final String ansiColor;

    private ConsoleColor(char code, int ansi256Code) {
        this.code = code;
        this.ansiColor = Ansi.ansi().reset().fg(ansi256Code).toString();
    }

    public static String format(String text) {
        for (ConsoleColor color : ConsoleColor.values()) {
            text = color.code == 'a' ? text.replace("&a", ConsoleColor.getPrimaryColor()) : text.replace("&" + color.code, color.ansiColor);
        }
        return text + String.valueOf(Ansi.ansi().reset());
    }

    private static String getPrimaryColor() {
        return Ansi.ansi().reset().fg(Node.getInstance().getConfig().getPrimaryColorCode()).toString();
    }
}

