/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.console;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import net.potatocloud.node.Node;
import net.potatocloud.node.console.Console;
import org.apache.commons.io.FileUtils;

public class Logger {
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String LATEST_LOG_FILENAME = "latest.log";
    private final Console console;
    private final Path logsFolder;
    private final List<String> cachedLogs = new ArrayList<String>();

    public Logger(Console console, Path logsFolder) {
        this.console = console;
        this.logsFolder = logsFolder;
        File latestLogFile = logsFolder.resolve(LATEST_LOG_FILENAME).toFile();
        if (latestLogFile.exists()) {
            latestLogFile.delete();
        }
    }

    public void info(String message) {
        this.log(Level.INFO, message);
    }

    public void warn(String message) {
        this.log(Level.WARN, message);
    }

    public void error(String message) {
        this.log(Level.ERROR, message);
    }

    public void logCommand(String command) {
        this.log(Level.COMMAND, command);
    }

    private void log(Level level, String message) {
        Object uncoloredMessage;
        String coloredMessage;
        String time = TIME_FORMAT.format(new Date());
        String date = DATE_FORMAT.format(new Date());
        if (level.equals((Object)Level.COMMAND)) {
            coloredMessage = this.console.getPrompt() + message;
            uncoloredMessage = this.removeColorCodes(coloredMessage);
        } else {
            uncoloredMessage = "[" + time + " " + level.name() + "] " + this.removeColorCodes(message);
            coloredMessage = "&8[&7" + time + " " + level.getColorCode() + level.name() + "&8] &7" + message;
        }
        File dayLog = this.logsFolder.resolve(date + ".log").toFile();
        File latestLog = this.logsFolder.resolve(LATEST_LOG_FILENAME).toFile();
        FileUtils.writeStringToFile(dayLog, (String)uncoloredMessage + System.lineSeparator(), StandardCharsets.UTF_8, true);
        FileUtils.writeStringToFile(latestLog, (String)uncoloredMessage + System.lineSeparator(), StandardCharsets.UTF_8, true);
        this.cachedLogs.add(coloredMessage);
        boolean isNodeScreen = Node.getInstance().getScreenManager().getCurrentScreen().getName().equals("node_screen");
        if (!level.equals((Object)Level.COMMAND) && isNodeScreen) {
            this.console.println(coloredMessage);
        }
    }

    public List<String> getCachedLogs() {
        return Collections.unmodifiableList(this.cachedLogs);
    }

    private String removeColorCodes(String input) {
        String s = input;
        s = s.replaceAll("&.", "");
        s = s.replaceAll("\u001b\\[[;\\d]*m", "");
        return s;
    }

    public static enum Level {
        INFO("&a"),
        WARN("&e"),
        ERROR("&c"),
        COMMAND("&7");

        private final String colorCode;

        private Level(String colorCode) {
            this.colorCode = colorCode;
        }

        @Generated
        public String getColorCode() {
            return this.colorCode;
        }
    }
}

