/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.group;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.group.ServiceGroupManager;
import net.potatocloud.api.group.impl.ServiceGroupImpl;
import net.potatocloud.api.property.Property;
import net.potatocloud.api.service.Service;
import net.potatocloud.core.networking.NetworkServer;
import net.potatocloud.core.networking.packets.group.GroupAddPacket;
import net.potatocloud.core.networking.packets.group.GroupUpdatePacket;
import net.potatocloud.node.Node;
import net.potatocloud.node.group.ServiceGroupStorage;
import net.potatocloud.node.group.listeners.GroupAddListener;
import net.potatocloud.node.group.listeners.GroupDeleteListener;
import net.potatocloud.node.group.listeners.GroupUpdateListener;
import net.potatocloud.node.group.listeners.RequestGroupsListener;

public class ServiceGroupManagerImpl
implements ServiceGroupManager {
    private final List<ServiceGroup> groups = new ArrayList<ServiceGroup>();
    private final Path groupsPath;
    private final NetworkServer server;

    public ServiceGroupManagerImpl(Path groupsPath, NetworkServer server) {
        this.groupsPath = groupsPath;
        this.server = server;
        server.registerPacketListener(100, new RequestGroupsListener(this));
        server.registerPacketListener(102, new GroupUpdateListener(this));
        server.registerPacketListener(101, new GroupAddListener(this));
        server.registerPacketListener(104, new GroupDeleteListener(this));
    }

    @Override
    public ServiceGroup getServiceGroup(String name) {
        return this.groups.stream().filter(cloudServiceGroup -> cloudServiceGroup.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    @Override
    public List<ServiceGroup> getAllServiceGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    @Override
    public void createServiceGroup(String name, String platformName, String platformVersionName, int minOnlineCount, int maxOnlineCount, int maxPlayers, int maxMemory, boolean fallback, boolean isStatic, int startPriority, int startPercentage, String javaCommand, List<String> customJvmFlags, Map<String, Property<?>> propertyMap) {
        if (this.existsServiceGroup(name)) {
            return;
        }
        ServiceGroupImpl serviceGroup = new ServiceGroupImpl(name, platformName, platformVersionName, minOnlineCount, maxOnlineCount, maxPlayers, maxMemory, fallback, isStatic, startPriority, startPercentage, javaCommand, customJvmFlags, propertyMap);
        this.addServiceGroup(serviceGroup);
        this.server.broadcastPacket(new GroupAddPacket(name, platformName, platformVersionName, serviceGroup.getServiceTemplates(), minOnlineCount, maxOnlineCount, maxPlayers, maxMemory, fallback, isStatic, startPriority, startPercentage, javaCommand, customJvmFlags, propertyMap));
        Node.getInstance().getLogger().info("Group &a" + name + " &7was successfully created");
    }

    public void addServiceGroup(ServiceGroup group) {
        if (group == null || this.existsServiceGroup(group.getName())) {
            return;
        }
        for (String templateName : group.getServiceTemplates()) {
            Node.getInstance().getTemplateManager().createTemplate(templateName);
        }
        ServiceGroupStorage.saveToFile(group, this.groupsPath);
        this.groups.add(group);
    }

    @Override
    public void deleteServiceGroup(String name) {
        ServiceGroup group = this.getServiceGroup(name);
        if (group == null || !this.groups.contains(group)) {
            return;
        }
        group.getAllServices().forEach(Service::shutdown);
        this.groups.remove(group);
        Path filePath = this.groupsPath.resolve(name + ".yml");
        try {
            Files.deleteIfExists(filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateServiceGroup(ServiceGroup group) {
        ServiceGroupStorage.saveToFile(group, this.groupsPath);
        this.server.broadcastPacket(new GroupUpdatePacket(group.getName(), group.getMinOnlineCount(), group.getMaxOnlineCount(), group.getMaxPlayers(), group.getMaxMemory(), group.isFallback(), group.getStartPriority(), group.getStartPercentage(), group.getServiceTemplates(), group.getPropertyMap(), group.getCustomJvmFlags()));
    }

    @Override
    public boolean existsServiceGroup(String groupName) {
        if (groupName == null) {
            return false;
        }
        return this.groups.stream().anyMatch(serviceGroup -> serviceGroup != null && serviceGroup.getName().equalsIgnoreCase(groupName));
    }

    public void loadGroups() {
        if (!Files.exists(this.groupsPath, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> paths = Files.list(this.groupsPath);){
            paths.filter(path -> path.toString().endsWith(".yml")).forEach(path -> this.groups.add(ServiceGroupStorage.loadFromFile(path)));
        }
    }

    @Generated
    public Path getGroupsPath() {
        return this.groupsPath;
    }
}

