/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.platform;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import lombok.Generated;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.PlatformVersion;
import net.potatocloud.node.Node;
import net.potatocloud.node.console.Logger;
import net.potatocloud.node.platform.BuildParser;
import net.potatocloud.node.platform.PlatformUtils;
import net.potatocloud.node.platform.parser.PaperBuildParser;
import net.potatocloud.node.platform.parser.PurpurBuildParser;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;

public class DownloadManager {
    private final Path platformsFolder;
    private final Logger logger;
    private static final List<BuildParser> PARSERS = List.of(new PaperBuildParser("paper"), new PaperBuildParser("velocity"), new PurpurBuildParser());

    public void downloadPlatformVersion(Platform platform, PlatformVersion version) {
        if (platform == null) {
            this.logger.info("&cThis platform does not exist.");
            return;
        }
        if (!Files.exists(this.platformsFolder, new LinkOption[0])) {
            Files.createDirectories(this.platformsFolder, new FileAttribute[0]);
        }
        File platformFile = PlatformUtils.getPlatformJarFile(platform, version);
        if (version.isLocal()) {
            if (!platformFile.exists()) {
                this.logger.error("Platform &a" + platform.getName() + " &7version &a" + version.getName() + " &7does not exist!");
                return;
            }
            return;
        }
        BuildParser parser = PARSERS.stream().filter(p -> p.getName().equalsIgnoreCase(platform.getParser())).findFirst().orElse(null);
        if ((version.getDownloadUrl() == null || version.getDownloadUrl().isEmpty()) && parser != null) {
            parser.parse(version, platform.getDownloadUrl());
        }
        if (!platformFile.exists()) {
            this.download(platform, version, platformFile);
            return;
        }
        boolean autoUpdate = Node.getInstance().getConfig().isPlatformAutoUpdate();
        if (autoUpdate && this.needsUpdate(version, platformFile)) {
            this.logger.info("Platform &a" + platform.getName() + " &7is outdated! Downloading update&8...");
            this.download(platform, version, platformFile);
        }
    }

    private void download(Platform platform, PlatformVersion version, File platformFile) {
        this.logger.info("&7Downloading platform &a" + platform.getName() + "&7 version &a" + version.getName());
        if (version.getDownloadUrl() == null || version.getDownloadUrl().isEmpty()) {
            this.logger.error("No download URL found for platform: " + platform.getName());
            return;
        }
        FileUtils.copyURLToFile(URI.create(version.getDownloadUrl()).toURL(), platformFile, 5000, 5000);
        this.logger.info("&7Finished downloading platform &a" + platform.getName() + "&7 version &a" + version.getName());
    }

    private boolean needsUpdate(PlatformVersion version, File platformFile) {
        boolean bl;
        String versionHash = version.getFileHash();
        if (versionHash == null || versionHash.isEmpty()) {
            return false;
        }
        try (FileInputStream stream = new FileInputStream(platformFile);){
            String currentFileHash = version.getPlatform().getHashType().equals("md5") ? DigestUtils.md5Hex(stream) : DigestUtils.sha256Hex(stream);
            bl = !currentFileHash.equalsIgnoreCase(versionHash);
        }
        return bl;
    }

    @Generated
    public DownloadManager(Path platformsFolder, Logger logger) {
        this.platformsFolder = platformsFolder;
        this.logger = logger;
    }
}

