/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.platform;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.PlatformVersion;
import net.potatocloud.api.platform.impl.PlatformImpl;
import net.potatocloud.api.platform.impl.PlatformVersionImpl;
import net.potatocloud.node.console.Logger;
import org.apache.commons.io.FileUtils;
import org.simpleyaml.configuration.ConfigurationSection;
import org.simpleyaml.configuration.file.YamlFile;

public class PlatformFileHandler {
    private final Logger logger;
    private final File file;
    private final YamlFile config;

    public PlatformFileHandler(Logger logger) {
        this.logger = logger;
        this.file = new File("platforms.yml");
        if (!this.file.exists()) {
            try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream("platforms.yml");){
                if (stream != null) {
                    FileUtils.copyInputStreamToFile(stream, this.file);
                }
            }
            catch (IOException e) {
                logger.error("Failed to copy platforms.yml file");
            }
        }
        this.config = this.mergePlatformsFile();
    }

    public List<Platform> loadPlatformsFile() {
        ArrayList<Platform> platforms = new ArrayList<Platform>();
        for (String key : this.config.getKeys(false)) {
            ConfigurationSection section = this.config.getConfigurationSection(key);
            if (section == null) continue;
            PlatformImpl platform = new PlatformImpl(key, section.getString("download"), section.getBoolean("custom", false), section.getBoolean("proxy", false), section.getString("base", "UNKNOWN"), section.getString("pre-cache"), section.getString("parser", ""), section.getString("hash-type", ""), section.getStringList("prepare-steps"));
            List<Map<?, ?>> versionMap = section.getMapList("versions");
            if (versionMap == null) {
                this.logger.warn("No versions found for platform " + key);
                continue;
            }
            ArrayList<PlatformVersionImpl> versions = new ArrayList<PlatformVersionImpl>();
            for (Map<?, ?> map : versionMap) {
                String version = String.valueOf(map.get("version"));
                String download = map.containsKey("download") ? String.valueOf(map.get("download")) : null;
                boolean legacy = map.containsKey("legacy") && Boolean.parseBoolean(map.get("legacy").toString());
                boolean local = map.containsKey("local") && Boolean.parseBoolean(map.get("local").toString());
                versions.add(new PlatformVersionImpl(key, version, local, download, legacy));
            }
            platform.getVersions().addAll(versions);
            platforms.add(platform);
        }
        return platforms;
    }

    private YamlFile mergePlatformsFile() {
        YamlFile userConfig = new YamlFile(this.file);
        userConfig.load();
        YamlFile defaultConfig = new YamlFile();
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream("platforms.yml");){
            if (stream != null) {
                defaultConfig.load(stream);
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to copy platforms.yml file");
        }
        YamlFile mergedConfig = new YamlFile();
        for (String key : userConfig.getKeys(false)) {
            ConfigurationSection section = userConfig.getConfigurationSection(key);
            if (section == null || !section.getBoolean("custom", false)) continue;
            mergedConfig.set(key, section);
        }
        for (String key : defaultConfig.getKeys(false)) {
            if (mergedConfig.contains(key)) continue;
            mergedConfig.set(key, defaultConfig.get(key));
        }
        mergedConfig.save(this.file);
        return mergedConfig;
    }

    public void updatePlatform(Platform platform) {
        ArrayList versions = new ArrayList();
        for (PlatformVersion version : platform.getVersions()) {
            LinkedHashMap<String, Object> versionMap = new LinkedHashMap<String, Object>();
            versionMap.put("version", version.getName());
            versionMap.put("download", version.getDownloadUrl());
            versionMap.put("legacy", version.isLegacy());
            versions.add(versionMap);
        }
        this.config.set(platform.getName() + ".versions", versions);
        this.config.save(this.file);
    }

    public void addPlatform(Platform platform) {
        if (platform == null) {
            return;
        }
        LinkedHashMap<String, Object> platformMap = new LinkedHashMap<String, Object>();
        this.putIfNotNull(platformMap, "download", platform.getDownloadUrl());
        this.putIfNotNull(platformMap, "base", platform.getBase());
        this.putIfNotNull(platformMap, "custom", platform.isCustom());
        this.putIfNotNull(platformMap, "pre-cache", platform.getPreCacheBuilder());
        this.putIfNotNull(platformMap, "parser", platform.getParser());
        this.putIfNotNull(platformMap, "proxy", platform.isProxy());
        this.putIfNotNull(platformMap, "hash-type", platform.getHashType());
        this.putIfNotNull(platformMap, "prepare-steps", new ArrayList<String>(platform.getPrepareSteps()));
        ArrayList<LinkedHashMap<String, Object>> versions = new ArrayList<LinkedHashMap<String, Object>>();
        for (PlatformVersion version : platform.getVersions()) {
            LinkedHashMap<String, Object> versionMap = new LinkedHashMap<String, Object>();
            this.putIfNotNull(versionMap, "version", version.getName());
            this.putIfNotNull(versionMap, "download", version.getDownloadUrl());
            this.putIfNotNull(versionMap, "legacy", version.isLegacy());
            this.putIfNotNull(versionMap, "local", version.isLocal());
            versions.add(versionMap);
        }
        this.putIfNotNull(platformMap, "versions", versions);
        this.config.set(platform.getName(), platformMap);
        this.config.save(this.file);
    }

    private void putIfNotNull(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }
}

