/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.platform.parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import net.potatocloud.api.platform.PlatformVersion;
import net.potatocloud.api.platform.impl.PlatformVersionImpl;
import net.potatocloud.node.platform.BuildParser;
import net.potatocloud.node.utils.RequestUtil;

public class PaperBuildParser
implements BuildParser {
    private final String projectName;

    @Override
    public void parse(PlatformVersion version, String baseUrl) {
        try {
            String versionName = version.getName();
            JsonObject project = RequestUtil.request("https://fill.papermc.io/v3/projects/" + this.projectName);
            JsonObject versions = project.getAsJsonObject("versions");
            if (versionName.equalsIgnoreCase("latest")) {
                ArrayList<String> allVersions = new ArrayList<String>();
                for (Map.Entry<String, JsonElement> entry : versions.entrySet()) {
                    JsonArray versionsArray = entry.getValue().getAsJsonArray();
                    for (JsonElement element : versionsArray) {
                        allVersions.add(element.getAsString());
                    }
                }
                versionName = (String)allVersions.getFirst();
            }
            JsonObject latestBuild = RequestUtil.request("https://fill.papermc.io/v3/projects/" + this.projectName + "/versions/" + versionName + "/builds/latest");
            int latestBuildId = latestBuild.get("id").getAsInt();
            JsonObject downloads = latestBuild.getAsJsonObject("downloads");
            JsonObject serverDefault = downloads.getAsJsonObject("server:default");
            String sha256 = serverDefault.getAsJsonObject("checksums").get("sha256").getAsString();
            String downloadUrl = baseUrl.replace("{version}", versionName).replace("{build}", String.valueOf(latestBuildId)).replace("{sha256}", sha256);
            if (version instanceof PlatformVersionImpl) {
                PlatformVersionImpl impl = (PlatformVersionImpl)version;
                impl.setFileHash(sha256);
                impl.setDownloadUrl(downloadUrl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return this.projectName;
    }

    @Generated
    public PaperBuildParser(String projectName) {
        this.projectName = projectName;
    }
}

