/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.platform.steps;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.PrepareStep;
import net.potatocloud.api.property.DefaultProperties;
import net.potatocloud.api.property.Property;
import net.potatocloud.api.service.Service;
import net.potatocloud.node.platform.VelocityForwardingSecret;
import net.potatocloud.node.utils.ProxyUtils;

public class SetupForwardingStep
implements PrepareStep {
    @Override
    public void execute(Service service, Platform platform, Path serverDirectory) {
        Property<Boolean> property;
        if (!service.getServiceGroup().getPlatform().isVelocityBased()) {
            return;
        }
        Path forwardingSecret = serverDirectory.resolve("forwarding.secret");
        if (!ProxyUtils.isProxyModernForwarding()) {
            if (!Files.exists(forwardingSecret, new LinkOption[0])) {
                Files.writeString(forwardingSecret, (CharSequence)UUID.randomUUID().toString(), StandardOpenOption.CREATE);
            }
            return;
        }
        Path velocityToml = serverDirectory.resolve("velocity.toml");
        if (Files.exists(velocityToml, new LinkOption[0])) {
            String fileContent = Files.readString(velocityToml);
            fileContent = fileContent.replace("player-info-forwarding-mode = \"legacy\"", "player-info-forwarding-mode = \"modern\"");
            Files.writeString(velocityToml, (CharSequence)fileContent, new OpenOption[0]);
        }
        boolean alwaysOverride = (property = service.getServiceGroup().getProperty(DefaultProperties.ALWAYS_OVERRIDE_FORWARDING_SECRET)) != null ? property.getValue() : DefaultProperties.ALWAYS_OVERRIDE_FORWARDING_SECRET.getDefaultValue();
        if (!Files.exists(forwardingSecret, new LinkOption[0]) || alwaysOverride) {
            Files.writeString(forwardingSecret, (CharSequence)VelocityForwardingSecret.FORWARDING_SECRET, StandardOpenOption.CREATE);
        }
    }

    @Override
    public String getName() {
        return "setup-forwarding";
    }
}

