/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.properties;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.potatocloud.api.property.Property;
import net.potatocloud.api.property.PropertyHolder;
import net.potatocloud.core.networking.NetworkServer;
import net.potatocloud.core.networking.packets.property.PropertyAddPacket;
import net.potatocloud.core.networking.packets.property.PropertyUpdatePacket;

public class NodePropertiesHolder
implements PropertyHolder {
    private final NetworkServer server;
    private final Map<String, Property<?>> propertyMap = new HashMap();

    public NodePropertiesHolder(NetworkServer server) {
        this.server = server;
        server.registerPacketListener(500, (connection, packet) -> this.propertyMap.values().forEach(property -> connection.send(new PropertyAddPacket((Property<?>)property))));
        server.registerPacketListener(503, (connection, packet) -> {
            this.propertyMap.put(packet.getProperty().getName(), packet.getProperty());
            server.getConnectedSessions().stream().filter(conn -> !conn.equals(connection)).forEach(conn -> conn.send(packet));
        });
        server.registerPacketListener(501, (connection, packet) -> {
            Property<?> property = this.propertyMap.get(packet.getName());
            if (property != null) {
                property.setValueObject(packet.getValue());
            }
            server.getConnectedSessions().stream().filter(conn -> !conn.equals(connection)).forEach(conn -> conn.send(packet));
        });
    }

    @Override
    public <T> void setProperty(Property<T> property, T value, boolean fireEvent) {
        Property existing = this.getProperty(property.getName());
        PropertyHolder.super.setProperty(property, value, fireEvent);
        if (existing == null) {
            this.server.broadcastPacket(new PropertyAddPacket(property));
        } else {
            this.server.broadcastPacket(new PropertyUpdatePacket(property.getName(), value));
        }
    }

    @Override
    public String getPropertyHolderName() {
        return "Global";
    }

    @Generated
    public NetworkServer getServer() {
        return this.server;
    }

    @Override
    @Generated
    public Map<String, Property<?>> getPropertyMap() {
        return this.propertyMap;
    }
}

