/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.service;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import lombok.Generated;
import net.potatocloud.node.config.NodeConfig;
import net.potatocloud.node.console.Logger;
import org.apache.commons.io.FileUtils;

public final class ServiceDefaultFiles {
    public static void copyDefaultFiles(Logger logger, NodeConfig config, ClassLoader classLoader) {
        Path dataFolder = Path.of(config.getDataFolder(), new String[0]);
        List<String> files = List.of("server.properties", "spigot.yml", "paper-global.yml", "velocity.toml", "limbo-server.properties", "potatocloud-plugin-spigot.jar", "potatocloud-plugin-velocity.jar", "potatocloud-plugin-limbo.jar");
        Files.createDirectories(dataFolder, new FileAttribute[0]);
        for (String name : files) {
            try {
                InputStream stream = classLoader.getResourceAsStream("default-files/" + name);
                try {
                    if (stream == null) continue;
                    FileUtils.copyInputStreamToFile(stream, dataFolder.resolve(name).toFile());
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                logger.warn("Failed to copy default service file: " + name);
            }
        }
    }

    @Generated
    private ServiceDefaultFiles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

