/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.potatocloud.api.event.EventManager;
import net.potatocloud.api.group.ServiceGroup;
import net.potatocloud.api.group.ServiceGroupManager;
import net.potatocloud.api.service.Service;
import net.potatocloud.api.service.ServiceManager;
import net.potatocloud.core.networking.NetworkServer;
import net.potatocloud.core.networking.packets.service.ServiceAddPacket;
import net.potatocloud.core.networking.packets.service.ServiceUpdatePacket;
import net.potatocloud.node.config.NodeConfig;
import net.potatocloud.node.console.Console;
import net.potatocloud.node.console.Logger;
import net.potatocloud.node.platform.DownloadManager;
import net.potatocloud.node.platform.PlatformManagerImpl;
import net.potatocloud.node.platform.cache.CacheManager;
import net.potatocloud.node.screen.ScreenManager;
import net.potatocloud.node.service.ServiceImpl;
import net.potatocloud.node.service.listeners.RequestServicesListener;
import net.potatocloud.node.service.listeners.ServiceCopyListener;
import net.potatocloud.node.service.listeners.ServiceExecuteCommandListener;
import net.potatocloud.node.service.listeners.ServiceStartedListener;
import net.potatocloud.node.service.listeners.ServiceUpdateListener;
import net.potatocloud.node.service.listeners.StartServiceListener;
import net.potatocloud.node.service.listeners.StopServiceListener;
import net.potatocloud.node.template.TemplateManager;

public class ServiceManagerImpl
implements ServiceManager {
    private final List<Service> services = new CopyOnWriteArrayList<Service>();
    private final NodeConfig config;
    private final Logger logger;
    private final NetworkServer server;
    private final EventManager eventManager;
    private final ServiceGroupManager groupManager;
    private final ScreenManager screenManager;
    private final TemplateManager templateManager;
    private final PlatformManagerImpl platformManager;
    private final DownloadManager downloadManager;
    private final CacheManager cacheManager;
    private final Console console;

    public ServiceManagerImpl(NodeConfig config, Logger logger, NetworkServer server, EventManager eventManager, ServiceGroupManager groupManager, ScreenManager screenManager, TemplateManager templateManager, PlatformManagerImpl platformManager, DownloadManager downloadManager, CacheManager cacheManager, Console console) {
        this.config = config;
        this.logger = logger;
        this.server = server;
        this.eventManager = eventManager;
        this.groupManager = groupManager;
        this.screenManager = screenManager;
        this.templateManager = templateManager;
        this.platformManager = platformManager;
        this.downloadManager = downloadManager;
        this.cacheManager = cacheManager;
        this.console = console;
        server.registerPacketListener(4, new RequestServicesListener(this));
        server.registerPacketListener(3, new ServiceStartedListener(this, logger, eventManager));
        server.registerPacketListener(2, new ServiceUpdateListener(this));
        server.registerPacketListener(5, new StartServiceListener(this, groupManager));
        server.registerPacketListener(6, new StopServiceListener(this));
        server.registerPacketListener(7, new ServiceExecuteCommandListener(this));
        server.registerPacketListener(8, new ServiceCopyListener(this));
    }

    @Override
    public Service getService(String name) {
        return this.services.stream().filter(service -> service.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    @Override
    public List<Service> getAllServices() {
        return Collections.unmodifiableList(this.services);
    }

    @Override
    public void updateService(Service service) {
        this.server.broadcastPacket(new ServiceUpdatePacket(service.getName(), service.getStatus().name(), service.getMaxPlayers(), service.getPropertyMap()));
    }

    @Override
    public void startService(String groupName) {
        ServiceGroup group = this.groupManager.getServiceGroup(groupName);
        if (group == null) {
            return;
        }
        int serviceId = this.getFreeServiceId(group);
        int port = this.getServicePort(group);
        ServiceImpl service = new ServiceImpl(serviceId, port, group, this.config, this.logger, this.server, this.screenManager, this.templateManager, this.platformManager, this.downloadManager, this.cacheManager, this.eventManager, this, this.console);
        this.services.add(service);
        this.server.broadcastPacket(new ServiceAddPacket(service.getName(), service.getServiceId(), service.getPort(), service.getStartTimestamp(), service.getServiceGroup().getName(), service.getPropertyMap(), service.getStatus().name(), service.getMaxPlayers()));
        service.start();
    }

    @Override
    public void startServices(String groupName, int count) {
        for (int i = 0; i < count; ++i) {
            this.startService(groupName);
        }
    }

    public void removeService(Service service) {
        this.services.remove(service);
    }

    private int getFreeServiceId(ServiceGroup serviceGroup) {
        HashSet<Integer> usedIds = new HashSet<Integer>();
        for (Service service : this.services) {
            if (!service.getServiceGroup().equals(serviceGroup)) continue;
            usedIds.add(service.getServiceId());
        }
        int id = 1;
        while (usedIds.contains(id)) {
            ++id;
        }
        return id;
    }

    private int getServicePort(ServiceGroup group) {
        int port;
        HashSet<Integer> usedPorts = new HashSet<Integer>();
        for (Service service : this.services) {
            usedPorts.add(service.getPort());
        }
        int n = port = group.getPlatform().isProxy() ? this.config.getProxyStartPort() : this.config.getServiceStartPort();
        while (usedPorts.contains(port)) {
            ++port;
        }
        return port;
    }

    @Override
    public Service getCurrentService() {
        return null;
    }
}

