/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.setup;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.potatocloud.node.setup.AnswerAction;
import net.potatocloud.node.setup.AnswerResult;
import net.potatocloud.node.setup.Question;
import net.potatocloud.node.setup.QuestionSkipCondition;
import net.potatocloud.node.setup.QuestionType;
import net.potatocloud.node.setup.SuggestionProvider;
import net.potatocloud.node.setup.validator.AnswerValidator;

public abstract class AbstractQuestion
implements Question {
    private final String name;
    private final String prompt;
    private final QuestionType type;
    private QuestionSkipCondition skipCondition;
    private String defaultAnswer;
    private SuggestionProvider suggestions;
    private AnswerValidator customValidator;
    private AnswerAction answerAction;

    @Override
    public List<String> getSuggestions() {
        if (this.suggestions == null) {
            return null;
        }
        return this.suggestions.suggest();
    }

    @Override
    public boolean shouldSkip(Map<String, String> answers) {
        if (this.skipCondition == null) {
            return false;
        }
        return this.skipCondition.skip(answers);
    }

    @Override
    public boolean validateInput(String input) {
        AnswerResult result;
        AnswerValidator defaultValidator = this.getDefaultValidator();
        if (defaultValidator != null && !(result = defaultValidator.validateInput(input)).isSuccess()) {
            return false;
        }
        return this.customValidator == null || (result = this.customValidator.validateInput(input)).isSuccess();
    }

    @Override
    public String getValidatorError(String input) {
        AnswerResult result;
        AnswerValidator defaultValidator = this.getDefaultValidator();
        if (defaultValidator != null && !(result = defaultValidator.validateInput(input)).isSuccess()) {
            return result.getErrorMessage();
        }
        if (this.customValidator != null && !(result = this.customValidator.validateInput(input)).isSuccess()) {
            return result.getErrorMessage();
        }
        return "Error";
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getPrompt() {
        return this.prompt;
    }

    @Override
    @Generated
    public QuestionType getType() {
        return this.type;
    }

    @Generated
    public QuestionSkipCondition getSkipCondition() {
        return this.skipCondition;
    }

    @Override
    @Generated
    public String getDefaultAnswer() {
        return this.defaultAnswer;
    }

    @Override
    @Generated
    public AnswerValidator getCustomValidator() {
        return this.customValidator;
    }

    @Override
    @Generated
    public AnswerAction getAnswerAction() {
        return this.answerAction;
    }

    @Override
    @Generated
    public void setSkipCondition(QuestionSkipCondition skipCondition) {
        this.skipCondition = skipCondition;
    }

    @Override
    @Generated
    public void setDefaultAnswer(String defaultAnswer) {
        this.defaultAnswer = defaultAnswer;
    }

    @Override
    @Generated
    public void setSuggestions(SuggestionProvider suggestions) {
        this.suggestions = suggestions;
    }

    @Override
    @Generated
    public void setCustomValidator(AnswerValidator customValidator) {
        this.customValidator = customValidator;
    }

    @Override
    @Generated
    public void setAnswerAction(AnswerAction answerAction) {
        this.answerAction = answerAction;
    }

    @Generated
    public AbstractQuestion(String name, String prompt, QuestionType type) {
        this.name = name;
        this.prompt = prompt;
        this.type = type;
    }
}

