/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.setup.builder;

import lombok.Generated;
import net.potatocloud.node.setup.AnswerAction;
import net.potatocloud.node.setup.Question;
import net.potatocloud.node.setup.QuestionSkipCondition;
import net.potatocloud.node.setup.Setup;
import net.potatocloud.node.setup.SuggestionProvider;
import net.potatocloud.node.setup.validator.AnswerValidator;

public abstract class BaseQuestionBuilder {
    protected final Setup parent;
    protected final String name;
    protected final String prompt;
    private String defaultAnswer;
    private SuggestionProvider suggestions;
    private QuestionSkipCondition skipIf;
    private AnswerValidator customValidator;
    private AnswerAction answerAction;

    public abstract Question question();

    public void add() {
        Question question = this.question();
        if (this.defaultAnswer != null) {
            question.setDefaultAnswer(this.defaultAnswer);
        }
        if (this.suggestions != null) {
            question.setSuggestions(this.suggestions);
        }
        if (this.skipIf != null) {
            question.setSkipCondition(this.skipIf);
        }
        if (this.customValidator != null) {
            question.setCustomValidator(this.customValidator);
        }
        if (this.answerAction != null) {
            question.setAnswerAction(this.answerAction);
        }
        this.parent.getQuestions().add(question);
    }

    @Generated
    public BaseQuestionBuilder(Setup parent, String name, String prompt) {
        this.parent = parent;
        this.name = name;
        this.prompt = prompt;
    }

    @Generated
    public BaseQuestionBuilder defaultAnswer(String defaultAnswer) {
        this.defaultAnswer = defaultAnswer;
        return this;
    }

    @Generated
    public BaseQuestionBuilder suggestions(SuggestionProvider suggestions) {
        this.suggestions = suggestions;
        return this;
    }

    @Generated
    public BaseQuestionBuilder skipIf(QuestionSkipCondition skipIf) {
        this.skipIf = skipIf;
        return this;
    }

    @Generated
    public BaseQuestionBuilder customValidator(AnswerValidator customValidator) {
        this.customValidator = customValidator;
        return this;
    }

    @Generated
    public BaseQuestionBuilder answerAction(AnswerAction answerAction) {
        this.answerAction = answerAction;
        return this;
    }
}

