/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.setup.setups;

import java.io.File;
import java.util.List;
import java.util.Map;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.impl.PlatformVersionImpl;
import net.potatocloud.node.console.Console;
import net.potatocloud.node.console.Logger;
import net.potatocloud.node.screen.ScreenManager;
import net.potatocloud.node.setup.AnswerResult;
import net.potatocloud.node.setup.Setup;

public class AddVersionToPlatformSetup
extends Setup {
    private final Platform platform;
    private final Logger logger;

    public AddVersionToPlatformSetup(Console console, ScreenManager screenManager, Platform platform, Logger logger) {
        super(console, screenManager);
        this.platform = platform;
        this.logger = logger;
    }

    @Override
    public void initQuestions() {
        this.question("name").text("What is the name of the version?").customValidator(input -> {
            if (this.platform.hasVersion(input)) {
                return AnswerResult.error("This version already exists for this platform");
            }
            return AnswerResult.success();
        }).add();
        this.question("use_download").bool("Should this version be downloaded automatically?\n\nType 'yes' to use a download URL.\nType 'no' if you want to add the JAR file yourself.\n").answerAction((answers, answer) -> {
            boolean usingLocalFile;
            boolean bl = usingLocalFile = answer.equalsIgnoreCase("false") || answer.equalsIgnoreCase("no");
            if (usingLocalFile) {
                File platformFolder = new File("platforms/" + this.platform.getName() + "/" + answer);
                platformFolder.mkdirs();
            }
        }).suggestions(() -> List.of("true", "false", "yes", "no")).add();
        this.question("local_ready").text("Please copy your platform file to this folder /platforms/" + this.platform.getName() + "/<version-name> and name it " + this.platform.getName() + "-<version-name>.jar\nType 'done' when ready or 'cancel' to cancel.").customValidator(input -> {
            if (!input.equalsIgnoreCase("done") && !input.equalsIgnoreCase("cancel")) {
                return AnswerResult.error("Type done if you are ready or cancel to cancel");
            }
            return AnswerResult.success();
        }).skipIf(answers -> ((String)answers.get("use_download")).equalsIgnoreCase("true") || ((String)answers.get("use_download")).equalsIgnoreCase("yes")).suggestions(() -> List.of("done", "cancel")).add();
        this.question("has_template").bool("Does the platform have a template URL with placeholders like {sha256}, {version}, {build}?\nExample: https://fill-data.papermc.io/v1/objects/{sha256}/paper-{version}-{build}.jar\nCheck the platform file or type 'no' if unsure.\n").skipIf(answers -> {
            String useDownload = answers.getOrDefault("use_download", "false");
            return !useDownload.equalsIgnoreCase("true") && !useDownload.equalsIgnoreCase("yes");
        }).suggestions(() -> List.of("true", "false", "yes", "no")).add();
        this.question("download_url").text("What is the Download URL of this version?").customValidator(input -> {
            if (!input.startsWith("http://") && !input.startsWith("https://")) {
                return AnswerResult.error("Download URL must start with 'http://' or 'https://'");
            }
            return AnswerResult.success();
        }).skipIf(answers -> {
            String useDownload = answers.getOrDefault("use_download", "false");
            String hasTemplate = answers.getOrDefault("has_template", "false");
            return !useDownload.equalsIgnoreCase("true") && !useDownload.equalsIgnoreCase("yes") || hasTemplate.equalsIgnoreCase("true") || hasTemplate.equalsIgnoreCase("yes");
        }).add();
        this.question("legacy").bool("Is this a legacy version? (1.8)").suggestions(() -> List.of("true", "false", "yes", "no")).add();
    }

    @Override
    protected void onFinish(Map<String, String> answers) {
        boolean useDownload = Boolean.parseBoolean(answers.get("use_download"));
        boolean isLocal = !useDownload;
        String downloadUrl = answers.get("download_url");
        PlatformVersionImpl version = new PlatformVersionImpl(this.platform.getName(), answers.get("name"), isLocal, downloadUrl, Boolean.parseBoolean(answers.get("legacy")));
        this.platform.addVersion(version);
        this.platform.update();
        this.logger.info("Version &a" + version.getName() + " &7was added to platform &a" + this.platform.getName());
    }

    @Override
    public String getName() {
        return "Add Platform Version";
    }
}

