/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.setup.setups;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.potatocloud.api.platform.Platform;
import net.potatocloud.api.platform.PlatformManager;
import net.potatocloud.node.console.Console;
import net.potatocloud.node.console.Logger;
import net.potatocloud.node.screen.ScreenManager;
import net.potatocloud.node.setup.AnswerResult;
import net.potatocloud.node.setup.Setup;

public class PlatformConfigurationSetup
extends Setup {
    private final PlatformManager platformManager;
    private final Logger logger;

    public PlatformConfigurationSetup(Console console, ScreenManager screenManager, PlatformManager platformManager, Logger logger) {
        super(console, screenManager);
        this.platformManager = platformManager;
        this.logger = logger;
    }

    @Override
    public void initQuestions() {
        this.question("name").text("What is the name of the platform?").customValidator(input -> {
            if (this.platformManager.exists(input)) {
                return AnswerResult.error("A platform with the same name already exists");
            }
            return AnswerResult.success();
        }).add();
        this.question("base").text("What is the base of the platform?").customValidator(input -> {
            List<String> supportedBases = List.of("bukkit", "spigot", "paper", "velocity", "limbo");
            if (!supportedBases.contains(input)) {
                return AnswerResult.error("This base is not supported");
            }
            return AnswerResult.success();
        }).suggestions(() -> List.of("bukkit", "spigot", "paper", "velocity", "limbo")).add();
    }

    @Override
    protected void onFinish(Map<String, String> answers) {
        String name = answers.get("name");
        String base = answers.get("base");
        boolean proxy = false;
        String preCache = "";
        ArrayList<String> prepareSteps = new ArrayList();
        switch (base) {
            case "paper": {
                preCache = "paper";
                prepareSteps = List.of("default-files", "eula", "port", "setup-proxy");
                break;
            }
            case "purpur": {
                preCache = "purpur";
                prepareSteps = List.of("default-files", "eula", "port", "setup-proxy");
                break;
            }
            case "bukkit": 
            case "spigot": {
                preCache = null;
                prepareSteps = List.of("default-files", "eula", "port", "setup-proxy");
                break;
            }
            case "velocity": {
                proxy = true;
                preCache = null;
                prepareSteps = List.of("default-files", "port", "setup-forwarding");
                break;
            }
            case "limbo": {
                preCache = null;
                prepareSteps = List.of("default-files", "port", "setup-proxy");
            }
        }
        Platform platform = this.platformManager.createPlatform(name, null, true, proxy, base, preCache, null, null, prepareSteps);
        this.logger.info("&aTip&8: &7Add a version using&8: &aplatform version add " + platform.getName());
    }

    @Override
    public String getName() {
        return "Platform Configuration";
    }
}

