/*
 * Decompiled with CFR 0.152.
 */
package net.potatocloud.node.version;

import com.google.gson.JsonObject;
import lombok.Generated;
import net.potatocloud.node.console.Logger;
import net.potatocloud.node.utils.RequestUtil;

public class UpdateChecker {
    private static final String REPO_OWNER = "potatocloudmc";
    private static final String REPO_NAME = "potatocloud";
    private final Logger logger;

    public void checkForUpdates() {
        try {
            if (this.isUpdateAvailable()) {
                this.logger.warn("A new version is available! &8(&7Latest&8: &a" + this.getLatestVersion() + "&8, &7Current&8: &a1.4.0&8)");
                return;
            }
            this.logger.info("You are running the latest version&8!");
        }
        catch (Exception e) {
            this.logger.warn("Failed to check for updates: " + e.getMessage());
        }
    }

    public boolean isUpdateAvailable() {
        this.logger.info("Checking for updates&8...");
        return !this.getLatestVersion().equals("1.4.0");
    }

    public String getLatestVersion() {
        String url = "https://api.github.com/repos/potatocloudmc/potatocloud/releases/latest";
        JsonObject response = RequestUtil.request("https://api.github.com/repos/potatocloudmc/potatocloud/releases/latest");
        return response.get("tag_name").getAsString();
    }

    @Generated
    public UpdateChecker(Logger logger) {
        this.logger = logger;
    }
}

