/*
 * Decompiled with CFR 0.152.
 */
package org.jline.style;

import java.util.function.Function;

public final class InterpolationHelper {
    private static final char ESCAPE_CHAR = '\\';
    private static final String DELIM_START = "@{";
    private static final String DELIM_STOP = "}";
    private static final String MARKER = "@__";

    private InterpolationHelper() {
    }

    public static String substVars(String val2, Function<String, String> callback, boolean defaultsToEmptyString) throws IllegalArgumentException {
        return InterpolationHelper.unescape(InterpolationHelper.doSubstVars(val2, callback, defaultsToEmptyString));
    }

    private static String doSubstVars(String val2, Function<String, String> callback, boolean defaultsToEmptyString) throws IllegalArgumentException {
        int startDelim;
        int stopDelim = -1;
        do {
            int idx;
            stopDelim = val2.indexOf(DELIM_STOP, stopDelim + 1);
            while (stopDelim > 0 && val2.charAt(stopDelim - 1) == '\\') {
                stopDelim = val2.indexOf(DELIM_STOP, stopDelim + 1);
            }
            startDelim = val2.indexOf(DELIM_START);
            while (stopDelim >= 0 && (idx = val2.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
                if (idx >= stopDelim) continue;
                startDelim = idx;
            }
        } while (startDelim >= 0 && stopDelim >= 0 && stopDelim < startDelim + DELIM_START.length());
        if (startDelim < 0 || stopDelim < 0) {
            return val2;
        }
        String variable = val2.substring(startDelim + DELIM_START.length(), stopDelim);
        String substValue = null;
        if (variable.length() > 0 && callback != null) {
            substValue = callback.apply(variable);
        }
        if (substValue == null) {
            substValue = defaultsToEmptyString ? "" : "@__{" + variable + DELIM_STOP;
        }
        val2 = val2.substring(0, startDelim) + substValue + val2.substring(stopDelim + DELIM_STOP.length());
        val2 = InterpolationHelper.doSubstVars(val2, callback, defaultsToEmptyString);
        return val2;
    }

    private static String unescape(String val2) {
        val2 = val2.replaceAll(MARKER, "@");
        int escape = val2.indexOf(92);
        while (escape >= 0 && escape < val2.length() - 1) {
            char c = val2.charAt(escape + 1);
            if (c == '{' || c == '}' || c == '\\') {
                val2 = val2.substring(0, escape) + val2.substring(escape + 1);
            }
            escape = val2.indexOf(92, escape + 1);
        }
        return val2;
    }
}

