/*
 * Decompiled with CFR 0.152.
 */
package org.simpleyaml.configuration.implementation.snakeyaml;

import java.util.LinkedHashMap;
import org.simpleyaml.configuration.ConfigurationSection;
import org.simpleyaml.configuration.implementation.api.QuoteValue;
import org.simpleyaml.configuration.implementation.snakeyaml.SnakeYamlQuoteValue;
import org.simpleyaml.configuration.implementation.snakeyaml.lib.DumperOptions;
import org.simpleyaml.configuration.implementation.snakeyaml.lib.nodes.Node;
import org.simpleyaml.configuration.implementation.snakeyaml.lib.nodes.Tag;
import org.simpleyaml.configuration.implementation.snakeyaml.lib.representer.Represent;
import org.simpleyaml.configuration.implementation.snakeyaml.lib.representer.Representer;
import org.simpleyaml.configuration.implementation.snakeyaml.lib.representer.SafeRepresenter;
import org.simpleyaml.configuration.serialization.ConfigurationSerializable;
import org.simpleyaml.configuration.serialization.ConfigurationSerialization;

public class SnakeYamlRepresenter
extends Representer {
    private final DumperOptions dumperOptions;

    public SnakeYamlRepresenter(DumperOptions dumperOptions) {
        super(dumperOptions);
        this.dumperOptions = dumperOptions;
        this.multiRepresenters.put(ConfigurationSection.class, new RepresentConfigurationSection());
        this.multiRepresenters.put(ConfigurationSerializable.class, new RepresentConfigurationSerializable());
        this.multiRepresenters.put(QuoteValue.class, new RepresentQuoteValue());
    }

    protected final DumperOptions getDumperOptions() {
        return this.dumperOptions;
    }

    private final class RepresentQuoteValue
    implements Represent {
        private RepresentQuoteValue() {
        }

        @Override
        public Node representData(Object data) {
            QuoteValue quoteValue = (QuoteValue)data;
            DumperOptions.ScalarStyle quoteScalarStyle = SnakeYamlQuoteValue.getQuoteScalarStyle(quoteValue.getQuoteStyle());
            Object value = quoteValue.getValue();
            if (value == null) {
                return SnakeYamlRepresenter.this.representScalar(Tag.NULL, "", quoteScalarStyle);
            }
            DumperOptions.ScalarStyle defaultScalarStyle = SnakeYamlRepresenter.this.getDefaultScalarStyle();
            SnakeYamlRepresenter.this.setDefaultScalarStyle(quoteScalarStyle);
            Node node = SnakeYamlRepresenter.this.representData(value);
            SnakeYamlRepresenter.this.setDefaultScalarStyle(defaultScalarStyle);
            return node;
        }
    }

    private final class RepresentConfigurationSerializable
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSerializable() {
            super(SnakeYamlRepresenter.this);
        }

        @Override
        public Node representData(Object data) {
            ConfigurationSerializable serializable = (ConfigurationSerializable)data;
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            values.put("==", ConfigurationSerialization.getAlias(serializable.getClass()));
            values.putAll(serializable.serialize());
            return super.representData(values);
        }
    }

    private final class RepresentConfigurationSection
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSection() {
            super(SnakeYamlRepresenter.this);
        }

        @Override
        public Node representData(Object data) {
            return super.representData(((ConfigurationSection)data).getValues(false));
        }
    }
}

